/*
 * Decompiled with CFR 0.152.
 */
package hsplet.gui;

import hsplet.gui.ContentPane;
import hsplet.gui.HSPScreen;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class Bmscr
implements Serializable {
    private static final String fileVersionID = "$Id: Bmscr.java,v 1.2 2006/01/29 16:29:17 Yuki Exp $";
    private static final long serialVersionUID = 7942441592976959984L;
    public final HSPScreen screen;
    public final Component component;
    public final ContentPane contents;
    public final Window window;
    public final List controls = new ArrayList();
    public BufferedImage backImage;
    public Graphics2D backGraphics;
    public int cx;
    public int cy;
    public Font font;
    public int fontStyle;
    public Color color;
    public int gmode;
    public int gwidth;
    public int gheight;
    public int galpha;
    public int redraw;
    public Color transColor;
    public int owidth;
    public int oheight;
    public int mindy;
    public int mesw;
    public int mesh;
    public Font objfont;
    public final Object repaintLock = new Object();
    public int originx;
    public int originy;

    public Bmscr(HSPScreen screen, ContentPane contentPane) {
        this(screen, contentPane, contentPane.getSize());
    }

    public Bmscr(HSPScreen screen, ContentPane contentPane, Dimension bufferSize) {
        this.screen = screen;
        this.component = screen.asComponent();
        this.contents = contentPane;
        this.window = this.component instanceof Window ? (Window)this.component : null;
        this.init(Color.white, bufferSize);
    }

    public void init(Color backColor) {
        this.init(backColor, new Dimension(this.backImage.getWidth(), this.backImage.getHeight()));
    }

    public void init(Color backColor, Dimension bufferSize) {
        if (this.contents != null) {
            this.contents.removeAll();
        }
        this.controls.clear();
        if (this.contents != null) {
            this.contents.setSize(bufferSize);
        }
        this.backImage = new BufferedImage(Math.max(1, bufferSize.width), Math.max(1, bufferSize.height), 5);
        this.backGraphics = this.backImage.createGraphics();
        this.backGraphics.setColor(backColor);
        this.backGraphics.fillRect(0, 0, this.backImage.getWidth(), this.backImage.getHeight());
        this.cx = 0;
        this.cy = 0;
        this.font = new Font("Monospaced", 0, 18);
        this.fontStyle = 0;
        this.color = Color.black;
        this.gmode = 0;
        this.gwidth = 0;
        this.gheight = 0;
        this.galpha = 0;
        this.redraw = 1;
        this.transColor = Color.black;
        this.owidth = 64;
        this.oheight = 24;
        this.mindy = 0;
        this.mesw = 0;
        this.mesh = 0;
        this.objfont = null;
        this.originx = 0;
        this.originy = 0;
        this.backGraphics.setFont(this.font);
        this.backGraphics.setColor(this.color);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void redraw(int x, int y, int width, int height) {
        if (this.contents != null && this.redraw != 0) {
            try {
                Object object = this.repaintLock;
                synchronized (object) {
                    this.contents.repaint(x, y, width, height);
                    this.repaintLock.wait(10L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

