/*
 * Decompiled with CFR 0.152.
 */
package hsplet.function;

import hsplet.Context;
import hsplet.Task;
import hsplet.function.EndException;
import hsplet.function.FunctionBase;
import hsplet.function.GotoException;
import hsplet.function.JumpStatement;
import hsplet.function.RunException;
import hsplet.variable.DoubleArray;
import hsplet.variable.IntArray;
import hsplet.variable.Operand;
import hsplet.variable.StringArray;
import hsplet.variable.Variable;

public class ProgramCommand
extends FunctionBase {
    private static final String fileVersionID = "$Id: ProgramCommand.java,v 1.6 2006/01/29 16:29:20 Yuki Exp $";
    private static int waitCount = 0;

    public static void goto_(Context context, int label, boolean clearLoop) {
        if (clearLoop) {
            context.looplev.value = 0;
        }
        throw new GotoException(label);
    }

    public static void gosub(Context context, int label) {
        ++context.sublev.value;
        try {
            context.getRunnableCode().run(label);
        }
        finally {
            --context.sublev.value;
        }
    }

    public static Operand call(Context context, int label) {
        ++context.sublev.value;
        try {
            Operand operand = context.getRunnableCode().run(label);
            return operand;
        }
        finally {
            --context.sublev.value;
        }
    }

    public static void wait(Context context, Operand v, int vi) {
        if (++waitCount % 10000 == 0) {
            System.gc();
        }
        ProgramCommand.doTasks(context);
        int waitTime = FunctionBase.toInt(v, vi, context.lastWaitDuration);
        if (waitTime < 0) {
            context.error(3, "wait", "duration==" + waitTime);
            return;
        }
        context.lastWaitDuration = waitTime;
        try {
            Thread.sleep(Math.max(5, context.lastWaitDuration * 10));
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        context.lastAwaitTime = System.currentTimeMillis();
    }

    public static void await(Context context, Operand v, int vi) {
        if (++waitCount % 10000 == 0) {
            System.gc();
        }
        ProgramCommand.doTasks(context);
        int waitTime = FunctionBase.toInt(v, vi, 0);
        if (waitTime < 0) {
            context.error(3, "wait", "duration==" + waitTime);
            return;
        }
        long duration = context.lastAwaitTime + (long)waitTime - System.currentTimeMillis();
        try {
            if (duration > 0L) {
                Thread.sleep(duration);
            } else {
                Thread.sleep(0L);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        context.lastAwaitTime = System.currentTimeMillis();
    }

    private static void doTasks(Context context) {
        while (context.tasks.size() != 0) {
            Task task = (Task)context.tasks.get(0);
            context.tasks.remove(0);
            task.run(context);
        }
    }

    public static void dim(Context context, Operand v, int vi, int l0, int l1, int l2, int l3) {
        if (!(v instanceof Variable)) {
            context.error(6, "dim", "typeof( v )==" + v.getClass().getName());
            return;
        }
        ((Variable)v).value = new IntArray(Math.max(1, l0), Math.max(1, l1), Math.max(1, l2), Math.max(1, l3));
    }

    public static void sdim(Context context, Operand v, int vi, Operand lengthv, int lengthvi, int l0, int l1, int l2, int l3) {
        if (!(v instanceof Variable)) {
            context.error(6, "sdim", "typeof( v )==" + v.getClass().getName());
            return;
        }
        ((Variable)v).value = new StringArray(FunctionBase.toInt(lengthv, lengthvi, 64), Math.max(1, l0), Math.max(1, l1), Math.max(1, l2), Math.max(1, l3));
    }

    public static void dimtype(Context context, Operand v, int vi, int type, int l0, int l1, int l2, int l3) {
        if (!(v instanceof Variable)) {
            context.error(6, "dimtype", "typeof( v )==" + v.getClass().getName());
            return;
        }
        switch (type) {
            case 4: {
                ((Variable)v).value = new IntArray(Math.max(1, l0), Math.max(1, l1), Math.max(1, l2), Math.max(1, l3));
                break;
            }
            case 3: {
                ((Variable)v).value = new DoubleArray(Math.max(1, l0), Math.max(1, l1), Math.max(1, l2), Math.max(1, l3));
                break;
            }
            case 2: {
                ((Variable)v).value = new StringArray(64, Math.max(1, l0), Math.max(1, l1), Math.max(1, l2), Math.max(1, l3));
            }
        }
    }

    public static void dup(Context context, Operand v, int vi, Operand v2, int v2i) {
        if (!(v instanceof Variable)) {
            context.error(6, "dup", "typeof( v )==" + v.getClass().getName());
            return;
        }
        Operand ref = v2.ref(v2i);
        ((Variable)v).value = ref instanceof Variable ? ((Variable)ref).value : ref;
    }

    public static void dupptr(Context context, Operand v, int vi) {
        context.error(21, "dupptr");
    }

    public static void end(Context context, int exitCode) {
        try {
            System.exit(exitCode);
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new EndException();
    }

    public static void stop(Context context) {
        try {
            while (true) {
                if (++waitCount % 10000 == 0) {
                    System.gc();
                }
                ProgramCommand.doTasks(context);
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return;
        }
    }

    public static void newmod(Context context, Operand v, int vi) {
        context.error(21, "newmod");
    }

    public static void setmod(Context context, Operand v, int vi) {
        context.error(21, "strmod");
    }

    public static void delmod(Context context, Operand v, int vi) {
        context.error(21, "delmod");
    }

    public static void alloc(Context context, int label) {
        context.error(21, "alloc");
    }

    public static void mref(Context context, Operand v, int vi, int type) {
        if (!(v instanceof Variable)) {
            context.error(6, "mref", "typeof( v )==" + v.getClass().getName());
            return;
        }
        switch (type) {
            case 64: {
                ((Variable)v).value = context.stat;
                break;
            }
            case 65: {
                ((Variable)v).value = context.refdval;
            }
        }
    }

    public static void run(Context context, String axName, String cmdline) {
        if (axName == null) {
            context.error(5, "run", "axName==");
            return;
        }
        try {
            throw new RunException(Class.forName(axName.toLowerCase().endsWith(".ax") ? axName.substring(0, axName.length() - ".ax".length()) : axName), cmdline);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            context.error(14, "run", axName);
            return;
        }
    }

    public static void exgoto(Context context, int a, int mode, int b, int label) {
        if (mode >= 0) {
            if (a >= b) {
                ProgramCommand.goto_(context, label, false);
            }
        } else if (a <= b) {
            ProgramCommand.goto_(context, label, false);
        }
    }

    public static void on(Context context, int index, JumpStatement jump, int[] labels) {
        if (index >= 0 && index < labels.length) {
            if (jump == null || jump == JumpStatement.Goto) {
                ProgramCommand.goto_(context, labels[index], false);
            } else {
                ProgramCommand.gosub(context, labels[index]);
            }
        }
    }

    public static void mcall(Context context, Operand v, int vi) {
        context.error(21, "mcall");
    }

    public static void assert_(Context context, Operand v, int vi) {
        context.error(21, "assert");
    }

    public static void logmes(Context context, String text) {
        System.out.println(text);
    }
}

