/*
 * Decompiled with CFR 0.152.
 */
package hsplet.gui;

import hsplet.gui.HSPControl;
import hsplet.variable.Operand;
import hsplet.variable.Scalar;
import hsplet.variable.Variable;
import hsplet.variable.VolatileValue;
import hsplet.variable.VolatileValueUpdater;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;

public class Combox
extends JComboBox
implements VolatileValueUpdater,
HSPControl,
ItemListener {
    private static final String fileVersionID = "$Id: Combox.java,v 1.4 2006/02/11 17:19:31 Yuki Exp $";
    private static final long serialVersionUID = -8777787617022303507L;
    private VolatileValue v;
    private int vi;

    public Combox(Variable v, int vi, String[] items) {
        int i = 0;
        while (i < items.length) {
            this.addItem(items[i]);
            ++i;
        }
        this.setSelectedIndex(v.toInt(vi));
        this.v = v.makeVolatile();
        this.vi = vi;
        this.addItemListener(this);
    }

    public Component asComponent() {
        return this;
    }

    public void setValue(Operand v, int vi) {
        switch (v.getType()) {
            case 4: {
                this.setSelectedIndex(v.toInt(vi));
                break;
            }
            default: {
                int selection = this.getSelectedIndex();
                this.removeAll();
                String[] items = v.toString(vi).split("\\r?\\n");
                int i = 0;
                while (i < items.length) {
                    this.addItem(items[i]);
                    ++i;
                }
                this.setSelectedIndex(selection < this.getItemCount() ? selection : -1);
            }
        }
        this.v.updaters.add(this);
    }

    public void update(Operand value) {
        value.assign(this.vi, Scalar.fromValue(this.getSelectedIndex()), 0);
    }

    public void itemStateChanged(ItemEvent e) {
        this.v.updaters.add(this);
    }

    public int sendMessage(int message, Operand wparam, Operand lparam) {
        throw new UnsupportedOperationException();
    }
}

