/*
 * Decompiled with CFR 0.152.
 */
package hsplet.gui;

import hsplet.gui.HSPControl;
import hsplet.variable.Operand;
import hsplet.variable.Scalar;
import hsplet.variable.Variable;
import hsplet.variable.VolatileValue;
import hsplet.variable.VolatileValueUpdater;
import java.awt.Component;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class Listbox
extends JScrollPane
implements VolatileValueUpdater,
HSPControl,
ListSelectionListener {
    private static final String fileVersionID = "$Id: Listbox.java,v 1.5 2006/02/27 15:52:04 Yuki Exp $";
    private static final long serialVersionUID = 8135061756805120960L;
    private VolatileValue v;
    private int vi;
    private final JList list;

    public Listbox(Variable v, int vi, String[] items) {
        super(20, 31);
        this.list = new JList<String>(items);
        this.list.setSelectedIndex(v.toInt(vi));
        this.v = v.makeVolatile();
        this.vi = vi;
        this.list.addListSelectionListener(this);
        this.setViewportView(this.list);
    }

    public void update(Operand value) {
        value.assign(this.vi, Scalar.fromValue(this.list.getSelectedIndex()), 0);
    }

    public Component asComponent() {
        return this;
    }

    public void setValue(Operand v, int vi) {
        switch (v.getType()) {
            case 4: {
                this.list.setSelectedIndex(v.toInt(vi));
                break;
            }
            default: {
                int selection = this.list.getSelectedIndex();
                this.removeAll();
                this.list.setListData(v.toString(vi).split("\\r?\\n"));
                this.list.setSelectedIndex(selection < this.list.getModel().getSize() ? selection : -1);
            }
        }
        this.v.updaters.add(this);
    }

    public void valueChanged(ListSelectionEvent e) {
        this.v.updaters.add(this);
    }

    public int sendMessage(int message, Operand wparam, Operand lparam) {
        throw new UnsupportedOperationException();
    }
}

