/*
 * Decompiled with CFR 0.152.
 */
package hsplet.variable;

import hsplet.variable.ByteString;
import hsplet.variable.Operand;
import hsplet.variable.Scalar;

public class IntScalar
extends Scalar {
    private static final String fileVersionID = "$Id: IntScalar.java,v 1.2 2006/01/13 20:32:13 Yuki Exp $";
    private static final long serialVersionUID = -798941318580432310L;
    public int value;

    public IntScalar(int value) {
        this.value = value;
    }

    public int getType() {
        return 4;
    }

    public String toString(int index) {
        return Integer.toString(this.value);
    }

    public ByteString toByteString(int index) {
        return new ByteString(Integer.toString(this.value));
    }

    public int toInt(int index) {
        return this.value;
    }

    public double toDouble(int index) {
        return this.value;
    }

    public void inc(int index) {
        ++this.value;
    }

    public void dec(int index) {
        --this.value;
    }

    public void assign(int index, Operand rhs, int rhi) {
        this.value = rhs.toInt(rhi);
    }

    public void assignAdd(int index, Operand rhs, int rhi) {
        this.value += rhs.toInt(rhi);
    }

    public void assignSub(int index, Operand rhs, int rhi) {
        this.value -= rhs.toInt(rhi);
    }

    public void assignMul(int index, Operand rhs, int rhi) {
        this.value *= rhs.toInt(rhi);
    }

    public void assignDiv(int index, Operand rhs, int rhi) {
        this.value /= rhs.toInt(rhi);
    }

    public void assignMod(int index, Operand rhs, int rhi) {
        this.value %= rhs.toInt(rhi);
    }

    public void assignAnd(int index, Operand rhs, int rhi) {
        this.value &= rhs.toInt(rhi);
    }

    public void assignOr(int index, Operand rhs, int rhi) {
        this.value |= rhs.toInt(rhi);
    }

    public void assignXor(int index, Operand rhs, int rhi) {
        this.value ^= rhs.toInt(rhi);
    }

    public void assignSr(int index, Operand rhs, int rhi) {
        this.value >>= rhs.toInt(rhi);
    }

    public void assignSl(int index, Operand rhs, int rhi) {
        this.value <<= rhs.toInt(rhi);
    }

    public Operand add(int index, Operand rhs, int rhi) {
        return Scalar.fromValue(this.value + rhs.toInt(rhi));
    }

    public Operand eq(int index, Operand rhs, int rhi) {
        return Scalar.fromValue(this.value == rhs.toInt(rhi) ? 1 : 0);
    }

    public Operand ne(int index, Operand rhs, int rhi) {
        return Scalar.fromValue(this.value != rhs.toInt(rhi) ? 1 : 0);
    }

    public Operand gt(int index, Operand rhs, int rhi) {
        return Scalar.fromValue(this.value > rhs.toInt(rhi) ? 1 : 0);
    }

    public Operand lt(int index, Operand rhs, int rhi) {
        return Scalar.fromValue(this.value < rhs.toInt(rhi) ? 1 : 0);
    }

    public Operand ge(int index, Operand rhs, int rhi) {
        return Scalar.fromValue(this.value >= rhs.toInt(rhi) ? 1 : 0);
    }

    public Operand le(int index, Operand rhs, int rhi) {
        return Scalar.fromValue(this.value <= rhs.toInt(rhi) ? 1 : 0);
    }

    public Operand sub(int index, Operand rhs, int rhi) {
        return Scalar.fromValue(this.value - rhs.toInt(rhi));
    }

    public Operand mul(int index, Operand rhs, int rhi) {
        return Scalar.fromValue(this.value * rhs.toInt(rhi));
    }

    public Operand div(int index, Operand rhs, int rhi) {
        return Scalar.fromValue(this.value / rhs.toInt(rhi));
    }

    public Operand mod(int index, Operand rhs, int rhi) {
        return Scalar.fromValue(this.value % rhs.toInt(rhi));
    }

    public Operand and(int index, Operand rhs, int rhi) {
        return Scalar.fromValue(this.value & rhs.toInt(rhi));
    }

    public Operand or(int index, Operand rhs, int rhi) {
        return Scalar.fromValue(this.value | rhs.toInt(rhi));
    }

    public Operand xor(int index, Operand rhs, int rhi) {
        return Scalar.fromValue(this.value ^ rhs.toInt(rhi));
    }

    public Operand sl(int index, Operand rhs, int rhi) {
        return Scalar.fromValue(this.value << rhs.toInt(rhi));
    }

    public Operand sr(int index, Operand rhs, int rhi) {
        return Scalar.fromValue(this.value >> rhs.toInt(rhi));
    }

    public byte peek(int index, int offset) {
        return (byte)(this.value >> offset % 4 * 8);
    }

    public void poke(int index, int offset, byte value) {
        this.value &= ~(255 << offset % 4 * 8);
        this.value |= (value & 0xFF) << offset % 4 * 8;
    }
}

