package hsplet.compiler.http;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;

/**
 * HTTP ̂ЂƂ̃ZbV̏sIuWFNg.
 *
 * @author Yuki
 * @version $Revision: 1.2 $, $Date: 2006/05/09 11:57:31 $
 */
public class HttpSession implements Runnable {

	/** sR[h. */
	private static final String CRLF = "\r\n";

	/** NCAgƂ̒ʐMp\Pbg. */
	private final Socket socket;

	/** T[o[IuWFNg. */
	private final HttpServer server;

	/**
	 * ZbV쐬.
	 * @param socket ʐMp\Pbg.
	 * @param server T[o[IuWFNg.
	 */
	public HttpSession(Socket socket, HttpServer server) {
		this.socket = socket;
		this.server = server;
	}

	/**
	 * ʐMs.
	 */
	public void run() {
		try {

			Set addressSet = new HashSet();
			addressSet.addAll(Arrays.asList(InetAddress.getAllByName(null)));
			addressSet.add(InetAddress.getLocalHost());

			if (!addressSet.contains(((InetSocketAddress) socket.getRemoteSocketAddress()).getAddress())) {
				System.out.println("Reject request from " + socket.getRemoteSocketAddress());
				socket.close();
				return;
			}

			final BufferedReader r = new BufferedReader(new InputStreamReader(socket.getInputStream()), 1024);

			final String request = r.readLine();

			final StringTokenizer tokenizer = new StringTokenizer(request, " ");

			final String method = tokenizer.nextToken(); // \bh͖EEEB
			final String uri = tokenizer.nextToken();

			// sڈȍ~͖EEEB

			sendContent(uri);

		} catch (IOException e) {
			throw new RuntimeException(e);
		} finally {
			try {
				socket.close();
			} catch (IOException ignored) {
			}
		}
	}

	/**
	 * URI Reg^Cv𓾂.
	 * <p>
	 * TODO e[upĂ葽̌`ɑΉ.
	 * </p>
	 * @param uri URI.
	 * @return Reg^Cv.
	 */
	private String getContentType(String uri) {
		if (uri.endsWith(".htm") || uri.endsWith(".html")) {
			return "text/html";
		} else if (uri.endsWith(".gif")) {
			return "image/gif";
		} else if (uri.endsWith(".txt")) {
			return "text/plain";
		} else {
			// Unknown case
			return "application/octet-stream";
		}
	}

	/**
	 * URI Ήt@C擾.
	 * @param uri URI.
	 * @return Ήt@CB null Ԃ邱ƂB
	 */
	private File getFile(String uri) {

		File file = server.mapPath(uri);
		if (file != null && file.isDirectory()) {
			if (new File(file, "index.htm").isFile()) {
				file = new File(file, "index.htm");
			} else if (new File(file, "index.html").isFile()) {
				file = new File(file, "index.html");
			}
		}

		return file;
	}

	/**
	 * ʏ탂[hŃX|XԂ.
	 * <code>uri</code>ŗ^ꂽURIt@CɕϊA
	 * ̃t@CI[vēeHTTP clientɕԂB
	 * Content-type̓t@C̊gq画fB
	 * t@CȂꍇɂ̓G[\y[W𐶐ĕԂB
	 *
	 * @param uri ^ꂽURI.
	 * @throws IOException o̓G[.
	 */
	private void sendContent(String uri) throws IOException {

		File file = getFile(uri);

		OutputStream o = socket.getOutputStream();
		OutputStreamWriter w = new OutputStreamWriter(o, "UTF-8");

		if (file != null && file.isFile()) {
			String contentType = getContentType(uri);

			w.write("HTTP/1.0 200 OK" + CRLF);
			w.write("Content-type: " + contentType + CRLF);
			w.write("Pragma: no-cache" + CRLF);
			w.write("Cache-Control: no-cache" + CRLF);
			w.write("Expires: Thu, 01 Dec 1994 16:00:00 GMT" + CRLF);
			w.write(CRLF);
			w.flush();

			InputStream in = new FileInputStream(file);
			byte[] buf = new byte[1024];

			for (;;) {
				int l = in.read(buf);
				if (l < 0) {
					break;
				}
				o.write(buf, 0, l);
			}
		} else {
			w.write("HTTP/1.0 404 Not found" + CRLF);
			w.write("Content-type: text/html" + CRLF);
			w.write("Pragma: no-cache" + CRLF);
			w.write("Cache-Control: no-cache" + CRLF);
			w.write("Expires: Thu, 01 Dec 1994 16:00:00 GMT" + CRLF);
			w.write(CRLF);
			w.write("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">");
			w.write("<html><head><title>404 Not Found</title></head><body>");
			w.write("<h1>404 Not found</h1>");
			w.write("<hr>");
			w.write("<table summary='Query Information'><tr><th>URI:</th><td>" + uri + "</td></tr>");
			w.write("<tr><th>File:</th><td>" + file + "</td></tr></table>");
			w.write("</p></body></html>");
			w.flush();
		}
		o.close();
	}
}
