/*
 * Decompiled with CFR 0.152.
 */
package hsplet.variable;

import hsplet.variable.Array;
import hsplet.variable.ByteString;
import hsplet.variable.DoubleScalar;
import hsplet.variable.IntScalar;
import hsplet.variable.Operand;

public final class DoubleArray
extends Array {
    private static final long serialVersionUID = 3145536222661277018L;
    private static final String fileVersionID = "$Id: DoubleArray.java,v 1.2 2006/01/13 20:32:12 Yuki Exp $";
    private double[] values;

    public DoubleArray() {
        this(16, 1, 1, 1);
    }

    public DoubleArray(int l0, int l1, int l2, int l3) {
        super(l0, l1, l2, l3);
        this.values = new double[l0 * l1 * l2 * l3];
    }

    public int getType() {
        return 3;
    }

    public String toString(int index) {
        return Double.toString(this.values[index]);
    }

    public ByteString toByteString(int index) {
        return new ByteString(Double.toString(this.values[index]));
    }

    public int toInt(int index) {
        return (int)this.values[index];
    }

    public double toDouble(int index) {
        return this.values[index];
    }

    public void inc(int index) {
        int n = index;
        this.values[n] = this.values[n] + 1.0;
    }

    public void dec(int index) {
        int n = index;
        this.values[n] = this.values[n] - 1.0;
    }

    public void assign(int index, Operand rhs, int rhi) {
        if (index >= this.values.length) {
            try {
                this.expand(index);
            }
            catch (Error e) {
                e.printStackTrace();
            }
        }
        this.values[index] = rhs.toDouble(rhi);
    }

    public void assignAdd(int index, Operand rhs, int rhi) {
        if (index >= this.values.length) {
            this.expand(index);
        }
        int n = index;
        this.values[n] = this.values[n] + rhs.toDouble(rhi);
    }

    public void assignSub(int index, Operand rhs, int rhi) {
        if (index >= this.values.length) {
            this.expand(index);
        }
        int n = index;
        this.values[n] = this.values[n] - rhs.toDouble(rhi);
    }

    public void assignMul(int index, Operand rhs, int rhi) {
        if (index >= this.values.length) {
            this.expand(index);
        }
        int n = index;
        this.values[n] = this.values[n] * rhs.toDouble(rhi);
    }

    public void assignDiv(int index, Operand rhs, int rhi) {
        if (index >= this.values.length) {
            this.expand(index);
        }
        int n = index;
        this.values[n] = this.values[n] / rhs.toDouble(rhi);
    }

    public void assignMod(int index, Operand rhs, int rhi) {
        if (index >= this.values.length) {
            this.expand(index);
        }
        int n = index;
        this.values[n] = this.values[n] % rhs.toDouble(rhi);
    }

    public void assignAnd(int index, Operand rhs, int rhi) {
        throw this.unsupportedOperator("&=");
    }

    public void assignOr(int index, Operand rhs, int rhi) {
        throw this.unsupportedOperator("|=");
    }

    public void assignXor(int index, Operand rhs, int rhi) {
        throw this.unsupportedOperator("^=");
    }

    public void assignSr(int index, Operand rhs, int rhi) {
        throw this.unsupportedOperator(">>=");
    }

    public void assignSl(int index, Operand rhs, int rhi) {
        throw this.unsupportedOperator("<<=");
    }

    public void expand(int index) {
        super.expand(index);
        double[] newValues = new double[this.l0 * this.l1 * this.l2 * this.l3];
        System.arraycopy(this.values, 0, newValues, 0, this.values.length);
        this.values = newValues;
    }

    public Operand add(int index, Operand rhs, int rhi) {
        return new DoubleScalar(this.values[index] + rhs.toDouble(rhi));
    }

    public Operand eq(int index, Operand rhs, int rhi) {
        return new IntScalar(this.values[index] == rhs.toDouble(rhi) ? 1 : 0);
    }

    public Operand ne(int index, Operand rhs, int rhi) {
        return new IntScalar(this.values[index] != rhs.toDouble(rhi) ? 1 : 0);
    }

    public Operand gt(int index, Operand rhs, int rhi) {
        return new IntScalar(this.values[index] > rhs.toDouble(rhi) ? 1 : 0);
    }

    public Operand lt(int index, Operand rhs, int rhi) {
        return new IntScalar(this.values[index] < rhs.toDouble(rhi) ? 1 : 0);
    }

    public Operand ge(int index, Operand rhs, int rhi) {
        return new IntScalar(this.values[index] >= rhs.toDouble(rhi) ? 1 : 0);
    }

    public Operand le(int index, Operand rhs, int rhi) {
        return new IntScalar(this.values[index] <= rhs.toDouble(rhi) ? 1 : 0);
    }

    public Operand sub(int index, Operand rhs, int rhi) {
        return new DoubleScalar(this.values[index] - rhs.toDouble(rhi));
    }

    public Operand mul(int index, Operand rhs, int rhi) {
        return new DoubleScalar(this.values[index] * rhs.toDouble(rhi));
    }

    public Operand div(int index, Operand rhs, int rhi) {
        return new DoubleScalar(this.values[index] / rhs.toDouble(rhi));
    }

    public Operand mod(int index, Operand rhs, int rhi) {
        return new DoubleScalar(this.values[index] % rhs.toDouble(rhi));
    }

    public Operand and(int index, Operand rhs, int rhi) {
        throw this.unsupportedOperator("&");
    }

    public Operand or(int index, Operand rhs, int rhi) {
        throw this.unsupportedOperator("|");
    }

    public Operand xor(int index, Operand rhs, int rhi) {
        throw this.unsupportedOperator("^");
    }

    public Operand sl(int index, Operand rhs, int rhi) {
        throw this.unsupportedOperator("<<");
    }

    public Operand sr(int index, Operand rhs, int rhi) {
        throw this.unsupportedOperator(">>");
    }

    public byte peek(int index, int offset) {
        return (byte)(Double.doubleToRawLongBits(this.values[index + offset / 8]) >> offset % 8 * 8);
    }

    public void poke(int index, int offset, byte value) {
        long bits = Double.doubleToRawLongBits(this.values[index + offset / 8]);
        bits &= 255L << offset % 8 * 8 ^ 0xFFFFFFFFFFFFFFFFL;
        this.values[index + offset / 8] = Double.longBitsToDouble(bits |= ((long)value & 0xFFL) << offset % 8 * 8);
    }
}

