/*
 * Decompiled with CFR 0.152.
 */
package hsplet.media;

import hsplet.Context;
import hsplet.media.HSPMedia;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;
import javazoom.jl.decoder.Bitstream;
import javazoom.jl.decoder.BitstreamException;
import javazoom.jl.decoder.Decoder;
import javazoom.jl.decoder.Header;
import javazoom.jl.decoder.JavaLayerException;
import javazoom.jl.decoder.SampleBuffer;
import javazoom.jl.player.AudioDevice;
import javazoom.jl.player.FactoryRegistry;

public class Mp3
implements HSPMedia {
    private static final String fileVersionID = "$Id: Mp3.java,v 1.7 2006/02/05 10:08:14 Yuki Exp $";
    private static final long serialVersionUID = 4705909472249775632L;
    private Context context;
    private URL dir;
    private String fileName;
    private Bitstream bitstream;
    private Decoder decoder;
    private AudioDevice audio;
    private int mode;
    protected boolean playing;
    private long skipLength;
    private long referencePosition;
    private long referenceTime;

    public Mp3(Context context, String fileName, int mode) throws Exception {
        this.context = context;
        this.dir = context.curdir;
        this.fileName = fileName;
        this.mode = mode;
        this.initialize();
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    public void dispose() {
        if (this.bitstream != null) {
            try {
                this.bitstream.close();
            }
            catch (BitstreamException e) {
                e.printStackTrace();
            }
        }
        if (this.audio != null) {
            this.audio.close();
        }
    }

    public boolean isPlaying() {
        return this.playing;
    }

    public void play() {
        this.playing = true;
        this.referenceTime = System.currentTimeMillis();
        this.referencePosition = this.audio.getPosition();
        switch (this.mode) {
            case 0: {
                Thread thread = new Thread(){

                    public void run() {
                        try {
                            while (Mp3.this.isPlaying()) {
                                if (!Mp3.this.nextFrame(false)) break;
                            }
                            Mp3.this.stop();
                        }
                        catch (JavaLayerException e) {
                            e.printStackTrace();
                        }
                    }
                };
                thread.setPriority(10);
                thread.start();
                return;
            }
            case 1: {
                Thread thread = new Thread(){

                    /*
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public void run() {
                        try {
                            while (true) {
                                if (!Mp3.this.isPlaying()) {
                                    Mp3.this.stop();
                                    return;
                                }
                                while (Mp3.this.isPlaying() && Mp3.this.nextFrame(false)) {
                                }
                                Mp3.this.setPosition(0);
                            }
                        }
                        catch (JavaLayerException e) {
                            e.printStackTrace();
                        }
                    }
                };
                thread.setPriority(10);
                thread.start();
                return;
            }
            case 2: {
                try {
                    while (this.isPlaying()) {
                        if (!this.nextFrame(false)) break;
                    }
                    this.stop();
                }
                catch (JavaLayerException e) {
                    e.printStackTrace();
                }
                return;
            }
        }
    }

    public void stop() {
        this.playing = false;
    }

    /*
     * Unable to fully structure code
     */
    public void setPosition(int value) {
        if (value >= this.getPosition()) ** GOTO lbl15
        try {
            this.initialize();
            if (true) ** GOTO lbl15
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        do {
            try {
                if (this.nextFrame(true)) continue;
            }
            catch (JavaLayerException e) {
                e.printStackTrace();
            }
            break;
lbl15:
            // 3 sources

        } while (this.getPosition() < value);
    }

    public int getPosition() {
        if (this.playing) {
            long playPosition;
            long playTime = System.currentTimeMillis() - this.referenceTime;
            if (playTime < (playPosition = (long)this.audio.getPosition() - this.referencePosition) - 1000L) {
                this.referenceTime -= (playPosition - playTime) / 10L;
            } else if (playTime < playPosition - 10L) {
                this.referenceTime -= 10L;
            } else if (playTime > playPosition + 1000L) {
                this.referenceTime += (playTime - playPosition) / 10L;
            }
            if (playTime > playPosition + 10L) {
                this.referenceTime += 10L;
            }
            return (int)(playTime + this.referencePosition + this.skipLength / 1000L);
        }
        return (int)((long)this.audio.getPosition() + this.skipLength / 1000L);
    }

    protected boolean nextFrame(boolean skip) throws JavaLayerException {
        Header h = this.bitstream.readFrame();
        if (h == null) {
            return false;
        }
        SampleBuffer output = (SampleBuffer)this.decoder.decodeFrame(h, this.bitstream);
        if (output == null) {
            return false;
        }
        if (skip) {
            this.skipLength = (long)((float)this.skipLength + h.ms_per_frame() * 1000.0f);
        } else {
            this.audio.write(output.getBuffer(), 0, output.getBufferLength());
        }
        this.bitstream.closeFrame();
        this.getPosition();
        return true;
    }

    protected void initialize() throws Exception {
        this.dispose();
        this.skipLength = 0L;
        InputStream in = this.context.getResource(this.dir, this.fileName);
        if (in == null) {
            throw new FileNotFoundException(String.valueOf(this.fileName) + " not found");
        }
        try {
            this.bitstream = new Bitstream(in);
            this.decoder = new Decoder();
            this.audio = FactoryRegistry.systemRegistry().createAudioDevice();
            this.audio.open(this.decoder);
        }
        catch (Exception e) {
            if (in != null) {
                in.close();
            }
            throw e;
        }
    }
}

