/*
 * Decompiled with CFR 0.152.
 */
package hsplet.media;

import hsplet.Context;
import hsplet.media.HSPMedia;
import java.io.FileNotFoundException;
import java.io.InputStream;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequencer;

public class Music
implements HSPMedia {
    private static final String fileVersionID = "$Id: Music.java,v 1.8 2006/02/05 10:08:14 Yuki Exp $";
    private static final long serialVersionUID = 9143714080541551764L;
    private Context context;
    private final Sequencer sequencer;
    private final int mode;
    private boolean playing;

    public Music(Context context, String fileName, int mode) throws Exception {
        this.context = context;
        this.sequencer = MidiSystem.getSequencer();
        this.mode = mode;
        InputStream in = context.getBufferedResource(fileName);
        if (in == null) {
            throw new FileNotFoundException(String.valueOf(fileName) + " not found");
        }
        try {
            this.sequencer.setSequence(in);
            this.sequencer.open();
        }
        catch (Exception e) {
            if (in != null) {
                in.close();
            }
            throw e;
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    public void dispose() {
        if (this.sequencer.isOpen()) {
            this.sequencer.stop();
            this.sequencer.close();
        }
    }

    public boolean isPlaying() {
        return this.playing;
    }

    public void play() {
        if (!this.sequencer.isOpen()) {
            return;
        }
        this.playing = true;
        switch (this.mode) {
            case 0: {
                this.sequencer.start();
                return;
            }
            case 1: {
                new Thread(){

                    public void run() {
                        while (Music.this.isPlaying()) {
                            if (!Music.this.sequencer.isOpen()) break;
                            Music.this.setPosition(0);
                            Music.this.sequencer.start();
                            try {
                                while (Music.this.sequencer.isRunning()) {
                                    Thread.sleep(100L);
                                }
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }.start();
                return;
            }
            case 2: {
                this.sequencer.start();
                try {
                    while (this.sequencer.isRunning()) {
                        Thread.sleep(100L);
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                return;
            }
        }
    }

    public void stop() {
        if (this.sequencer.isOpen()) {
            this.sequencer.stop();
        }
        this.playing = false;
    }

    public void setPosition(int value) {
        this.sequencer.setMicrosecondPosition((long)value * 1000L);
    }

    public int getPosition() {
        return (int)(this.sequencer.getMicrosecondPosition() / 1000L);
    }
}

