/*
 * $Id: HtmlGenerator.java,v 1.4 2006/01/16 19:34:22 Yuki Exp $
 */
package hsplet.compiler;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;

/**
 * HSPLet ŖړĨR[hs邽߂ HTML 𐶐NXB
 * <p>
 * ev[gǂݍŁAKvȉӏďo͂B
 * </p>
 * 
 * @author Yuki
 * @version $Revision: 1.4 $, $Date: 2006/01/16 19:34:22 $
 */
public final class HtmlGenerator implements Serializable {

	/** 񉻕ɁAf[^̌݊mF邽߂̃o[WԍB */
	private static final long serialVersionUID = -5216057552518726784L;

	/** ̃NX܂ރ\[Xt@C̃o[WB */
	private static final String fileVersionID = "$Id: HtmlGenerator.java,v 1.4 2006/01/16 19:34:22 Yuki Exp $";

	/** ev[gt@CB */
	private static final String TEMPLATE_NAME = "template.html";

	/** NXu^OB */
	private static final String START_CLASS_NAME_TAG_REGEX = "\\{START_CLASS_NAME\\}";

	/** ^Cgu^OB */
	private static final String TITLE_TAG_REGEX = "\\{TITLE\\}";

	/** mp3pCuu^OB */
	private static final String LIBS_TAG_REGEX = "\\{LIBS\\}";

	/** u^OB */
	private static final String WIDTH_TAG_REGEX = "\\{WIDTH\\}";

	/** u^OB */
	private static final String HEIGHT_TAG_REGEX = "\\{HEIGHT\\}";

	/** sNXB */
	private final String className;

	/** y[W^Cg */
	private final String title;

	/** gCuB */
	private final Collection libs;

	/** B */
	private final int width;

	/** B */
	private final int height;

	/** ev[gt@C */
	private final File template;

	/**
	 * sNXw肵ăIuWFNg\zB
	 * 
	 * @param className sNXB
	 * @param title y[W^CgB
	 * @param libs gCũXgB
	 * @param h 
	 * @param w 
	 * @param template ev[gt@CB
	 */
	public HtmlGenerator(final String className, final String title,
			final Collection libs, final int w, int h, final File template) {

		this.className = className;
		this.title = title;
		this.libs = libs;
		this.width = w;
		this.height = h;
		this.template = template;
	}

	/**
	 * HTML 𐶐B
	 * 
	 * @param out o͐B
	 * @throws IOException o̓G[ƂB
	 */
	public void generate(final OutputStream out) throws IOException {

		final PrintWriter w = new PrintWriter(out, true);

		final InputStream in = template == null ? getClass()
				.getResourceAsStream(TEMPLATE_NAME) : new FileInputStream(
				template);
		try {

			final BufferedReader r = new BufferedReader(new InputStreamReader(
					in));

			for (;;) {

				final String line = r.readLine();
				if (line == null) {
					break;
				}

				final StringBuffer extLibNames = new StringBuffer();
				for (final Iterator i = libs.iterator(); i.hasNext();) {
					extLibNames.append(i.next() + ",");
				}

				w.println(line
						.replaceAll(START_CLASS_NAME_TAG_REGEX, className)
						.replaceAll(LIBS_TAG_REGEX, extLibNames.toString())
						.replaceAll(WIDTH_TAG_REGEX, "" + width).replaceAll(
								HEIGHT_TAG_REGEX, "" + height).replaceAll(
								TITLE_TAG_REGEX, title));
			}
		} finally {
			in.close();
		}

	}

}
