/*
 * Decompiled with CFR 0.152.
 */
package hsplet.compiler;

import hsplet.compiler.ByteCode;
import hsplet.compiler.RuntimeInfo;
import hsplet.variable.ByteString;
import java.lang.reflect.Method;

public class DefaultRuntimeInfo
implements RuntimeInfo {
    private ClassLoader extLibLoader;
    private static final String fileVersionID = "$Id: DefaultRuntimeInfo.java,v 1.6 2006/01/16 19:34:22 Yuki Exp $";
    private static final long serialVersionUID = -9212746715730027401L;
    private static final String[][] basicFunctions;
    private static final String[] basicCommands;
    private static final String[] guiCommands;
    private static final String[] programCommands;
    private static final String[][] guiFunctions;
    private static final String[] controlCommands;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;

    static {
        String[][] stringArrayArray = new String[3][];
        stringArrayArray[0] = new String[]{"int_", "rnd", "strlen", "length", "length2", "length3", "length4", "vartype", "gettime", "peek", "wpeek", "lpeek", "varptr", "varuse", "noteinfo", "instr", "abs", "limit"};
        String[] stringArray = new String[5];
        stringArray[0] = "str";
        stringArray[1] = "strmid";
        stringArray[3] = "strf";
        stringArray[4] = "getpath";
        stringArrayArray[1] = stringArray;
        stringArrayArray[2] = new String[]{"sin", "cos", "tan", "atan", "sqrt", "double_", "absf", "expf", "logf", "limitf"};
        basicFunctions = stringArrayArray;
        String[] stringArray2 = new String[42];
        stringArray2[0] = "onexit";
        stringArray2[1] = "onerror";
        stringArray2[2] = "onkey";
        stringArray2[3] = "onclick";
        stringArray2[4] = "oncmd";
        stringArray2[17] = "exist";
        stringArray2[18] = "delete";
        stringArray2[19] = "mkdir";
        stringArray2[20] = "chdir";
        stringArray2[21] = "dirlist";
        stringArray2[22] = "bload";
        stringArray2[23] = "bsave";
        stringArray2[24] = "bcopy";
        stringArray2[25] = "memfile";
        stringArray2[26] = "poke";
        stringArray2[27] = "wpoke";
        stringArray2[28] = "lpoke";
        stringArray2[29] = "getstr";
        stringArray2[30] = "chdpm";
        stringArray2[31] = "memexpand";
        stringArray2[32] = "memcpy";
        stringArray2[33] = "memset";
        stringArray2[34] = "notesel";
        stringArray2[35] = "noteadd";
        stringArray2[36] = "notedel";
        stringArray2[37] = "noteload";
        stringArray2[38] = "notesave";
        stringArray2[39] = "randomize";
        stringArray2[40] = "noteunsel";
        stringArray2[41] = "noteget";
        basicCommands = stringArray2;
        String[] stringArray3 = new String[56];
        stringArray3[0] = "button";
        stringArray3[1] = "chgdips";
        stringArray3[2] = "exec";
        stringArray3[3] = "dialog";
        stringArray3[8] = "mmload";
        stringArray3[9] = "mmplay";
        stringArray3[10] = "mmstop";
        stringArray3[11] = "mci";
        stringArray3[12] = "pset";
        stringArray3[13] = "pget";
        stringArray3[14] = "syscolor";
        stringArray3[15] = "mes";
        stringArray3[16] = "title";
        stringArray3[17] = "pos";
        stringArray3[18] = "circle";
        stringArray3[19] = "cls";
        stringArray3[20] = "font";
        stringArray3[21] = "sysfont";
        stringArray3[22] = "objsize";
        stringArray3[23] = "picload";
        stringArray3[24] = "color";
        stringArray3[25] = "palcolor";
        stringArray3[26] = "palette";
        stringArray3[27] = "redraw";
        stringArray3[28] = "width";
        stringArray3[29] = "gsel";
        stringArray3[30] = "gcopy";
        stringArray3[31] = "gzoom";
        stringArray3[32] = "gmode";
        stringArray3[33] = "bmpsave";
        stringArray3[34] = "hsvcolor";
        stringArray3[35] = "getkey";
        stringArray3[36] = "listbobx";
        stringArray3[37] = "chkbox";
        stringArray3[38] = "combox";
        stringArray3[39] = "input";
        stringArray3[40] = "mesbox";
        stringArray3[41] = "buffer";
        stringArray3[42] = "screen";
        stringArray3[43] = "bgscr";
        stringArray3[44] = "mouse";
        stringArray3[45] = "objsel";
        stringArray3[46] = "groll";
        stringArray3[47] = "line";
        stringArray3[48] = "clrobj";
        stringArray3[49] = "boxf";
        stringArray3[50] = "objprm";
        stringArray3[51] = "objmode";
        stringArray3[52] = "stick";
        stringArray3[53] = "grect";
        stringArray3[54] = "grotate";
        stringArray3[55] = "gsquare";
        guiCommands = stringArray3;
        programCommands = new String[]{"goto_", "gosub", "return_", "break", "repeat", "loop", "continue_", "wait", "await", "dim", "sdim", "foreach", "foreachCheck", "dimtype", "dup", "dupptr", "end", "stop", "newmod", "setmod", "delmod", "alloc", "mref", "run", "exgoto", "on", "mcall", "assert_", "logmes"};
        guiFunctions = new String[][]{{"mousex", "mousey", "mousew", "hwnd", "hinstance", "hdc"}, {"ginfo", "objinfo", "dirinfo", "sysinfo"}};
        controlCommands = new String[]{"newcom", "querycom", "delcom", "convstow", "comres", "axobj", "winobj", "sendmsg", "comevent", "comevarg", "sarrayconv"};
    }

    public DefaultRuntimeInfo(ClassLoader extLibLoader) {
        this.extLibLoader = extLibLoader;
    }

    public Class getClassFor(ByteCode ax, ByteCode.Code code) {
        switch (code.type) {
            case 8: {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("hsplet.function.BasicCommand");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            case 9: {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("hsplet.function.GuiCommand");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            case 13: {
                Class<?> clazz = class$2;
                if (clazz == null) {
                    try {
                        clazz = class$2 = Class.forName("hsplet.function.BasicFunction");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            case 10: {
                Class<?> clazz = class$3;
                if (clazz == null) {
                    try {
                        clazz = class$3 = Class.forName("hsplet.function.GuiFunction");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            case 15: {
                Class<?> clazz = class$4;
                if (clazz == null) {
                    try {
                        clazz = class$4 = Class.forName("hsplet.function.ProgramCommand");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            case 12: {
                Class<?> clazz = class$4;
                if (clazz == null) {
                    try {
                        clazz = class$4 = Class.forName("hsplet.function.ProgramCommand");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            case 16: {
                ByteCode.Function func = ax.functions[code.value];
                ByteCode.Library lib = ax.libraries[func.index];
                String libName = new ByteString(ax.datas, lib.nameidx, false).toString();
                try {
                    if (libName.toLowerCase().endsWith(".dll") || libName.toLowerCase().endsWith(".hpi")) {
                        return this.extLibLoader.loadClass(libName.substring(0, libName.lastIndexOf(46)));
                    }
                    return this.extLibLoader.loadClass(libName);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
            case 17: {
                Class<?> clazz = class$5;
                if (clazz == null) {
                    try {
                        clazz = class$5 = Class.forName("hsplet.function.ControlCommand");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
        }
        throw new RuntimeException("\u547d\u4ee4\u30bf\u30a4\u30d7 " + code.type + " \u306f\u30af\u30e9\u30b9\u3068\u95a2\u9023\u4ed8\u3051\u3089\u308c\u307e\u305b\u3093\u3002");
    }

    public Method getMethodFor(ByteCode ax, ByteCode.Code code) {
        String name;
        Class clazz = this.getClassFor(ax, code);
        block0 : switch (code.type) {
            case 8: {
                name = basicCommands[code.value];
                break;
            }
            case 9: {
                name = guiCommands[code.value];
                break;
            }
            case 13: {
                switch (code.value & 0x180) {
                    case 0: {
                        name = basicFunctions[0][code.value & 0x7F];
                        break block0;
                    }
                    case 256: {
                        name = basicFunctions[1][code.value & 0x7F];
                        break block0;
                    }
                    case 384: {
                        name = basicFunctions[2][code.value & 0x7F];
                        break block0;
                    }
                }
                throw new UnsupportedOperationException("\u5185\u90e8\u95a2\u6570 " + code.value + " \u306f\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
            }
            case 10: {
                switch (code.value & 0x100) {
                    case 0: {
                        name = guiFunctions[0][code.value & 0xFF];
                        break block0;
                    }
                    case 256: {
                        name = guiFunctions[1][code.value & 0xFF];
                        break block0;
                    }
                }
                throw new UnsupportedOperationException("\u62e1\u5f35 GUI \u95a2\u6570 " + code.value + " \u306f\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
            }
            case 15: {
                name = programCommands[code.value];
                break;
            }
            case 12: {
                name = "call";
                break;
            }
            case 16: {
                ByteCode.Function func = ax.functions[code.value];
                String rawName = new ByteString(ax.datas, func.nameidx, false).toString();
                if (rawName.indexOf(64) >= 0) {
                    if (rawName.charAt(0) == '_') {
                        name = rawName.substring(1, rawName.indexOf(64));
                        break;
                    }
                    name = rawName.substring(0, rawName.indexOf(64));
                    break;
                }
                name = rawName;
                break;
            }
            case 17: {
                name = controlCommands[code.value];
                break;
            }
            default: {
                throw new RuntimeException("\u547d\u4ee4\u30bf\u30a4\u30d7 " + code.type + " \u306f\u30e1\u30bd\u30c3\u30c9\u3068\u95a2\u9023\u4ed8\u3051\u3089\u308c\u307e\u305b\u3093\u3002");
            }
        }
        Method[] methods = clazz.getMethods();
        int i = 0;
        while (i < methods.length) {
            Method m = methods[i];
            if (m.getName().equals(name)) {
                return m;
            }
            ++i;
        }
        return null;
    }
}

