/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.support.annotation.NonNull;
import android.util.Log;
import android.util.SparseArray;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzaav;
import com.google.android.gms.internal.zzaaw;
import com.google.android.gms.internal.zzaax;
import com.google.android.gms.internal.zzzw;
import java.io.FileDescriptor;
import java.io.PrintWriter;

public class zzzt
extends zzzw {
    private final SparseArray<zza> zzayx = new SparseArray();

    public static zzzt zza(zzaav zzaav2) {
        zzaax zzaax2 = zzzt.zzc((zzaav)zzaav2);
        zzzt zzzt2 = (zzzt)zzaax2.zza("AutoManageHelper", zzzt.class);
        if (zzzt2 != null) {
            return zzzt2;
        }
        return new zzzt(zzaax2);
    }

    private zzzt(zzaax zzaax2) {
        super(zzaax2);
        this.zzaBs.zza("AutoManageHelper", (zzaaw)this);
    }

    public void zza(int n, GoogleApiClient googleApiClient, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        zzac.zzb((Object)googleApiClient, (Object)"GoogleApiClient instance cannot be null");
        zzac.zza((this.zzayx.indexOfKey(n) < 0 ? 1 : 0) != 0, (Object)new StringBuilder(54).append("Already managing a GoogleApiClient with id ").append(n).toString());
        boolean bl = this.mStarted;
        boolean bl2 = this.zzayG;
        Log.d((String)"AutoManageHelper", (String)new StringBuilder(54).append("starting AutoManage for client ").append(n).append(" ").append(bl).append(" ").append(bl2).toString());
        zza zza2 = new zza(n, googleApiClient, onConnectionFailedListener);
        this.zzayx.put(n, (Object)zza2);
        if (this.mStarted && !this.zzayG) {
            String string2 = String.valueOf(googleApiClient);
            Log.d((String)"AutoManageHelper", (String)new StringBuilder(11 + String.valueOf(string2).length()).append("connecting ").append(string2).toString());
            googleApiClient.connect();
        }
    }

    public void zzcu(int n) {
        zza zza2 = (zza)this.zzayx.get(n);
        this.zzayx.remove(n);
        if (zza2 != null) {
            zza2.zzuX();
        }
    }

    @Override
    public void onStart() {
        super.onStart();
        int n = this.mStarted;
        Object object = String.valueOf(this.zzayx);
        Log.d((String)"AutoManageHelper", (String)new StringBuilder(14 + String.valueOf(object).length()).append("onStart ").append(n != 0).append(" ").append((String)object).toString());
        if (!this.zzayG) {
            for (n = 0; n < this.zzayx.size(); ++n) {
                object = (zza)this.zzayx.valueAt(n);
                ((zza)object).zzayz.connect();
            }
        }
    }

    @Override
    public void onStop() {
        super.onStop();
        for (int i = 0; i < this.zzayx.size(); ++i) {
            zza zza2 = (zza)this.zzayx.valueAt(i);
            zza2.zzayz.disconnect();
        }
    }

    public void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        for (int i = 0; i < this.zzayx.size(); ++i) {
            zza zza2 = (zza)this.zzayx.valueAt(i);
            zza2.dump(string2, fileDescriptor, printWriter, stringArray);
        }
    }

    @Override
    protected void zza(ConnectionResult connectionResult, int n) {
        Log.w((String)"AutoManageHelper", (String)"Unresolved error while connecting client. Stopping auto-manage.");
        if (n < 0) {
            Log.wtf((String)"AutoManageHelper", (String)"AutoManageLifecycleHelper received onErrorResolutionFailed callback but no failing client ID is set", (Throwable)new Exception());
            return;
        }
        zza zza2 = (zza)this.zzayx.get(n);
        if (zza2 != null) {
            this.zzcu(n);
            GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener = zza2.zzayA;
            if (onConnectionFailedListener != null) {
                onConnectionFailedListener.onConnectionFailed(connectionResult);
            }
        }
    }

    @Override
    protected void zzuW() {
        for (int i = 0; i < this.zzayx.size(); ++i) {
            zza zza2 = (zza)this.zzayx.valueAt(i);
            zza2.zzayz.connect();
        }
    }

    private class zza
    implements GoogleApiClient.OnConnectionFailedListener {
        public final int zzayy;
        public final GoogleApiClient zzayz;
        public final GoogleApiClient.OnConnectionFailedListener zzayA;

        public zza(int n, GoogleApiClient googleApiClient, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            this.zzayy = n;
            this.zzayz = googleApiClient;
            this.zzayA = onConnectionFailedListener;
            googleApiClient.registerConnectionFailedListener(this);
        }

        @Override
        public void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
            String string2 = String.valueOf(connectionResult);
            Log.d((String)"AutoManageHelper", (String)new StringBuilder(27 + String.valueOf(string2).length()).append("beginFailureResolution for ").append(string2).toString());
            zzzt.this.zzb(connectionResult, this.zzayy);
        }

        public void zzuX() {
            this.zzayz.unregisterConnectionFailedListener(this);
            this.zzayz.disconnect();
        }

        public void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
            printWriter.append(string2).append("GoogleApiClient #").print(this.zzayy);
            printWriter.println(":");
            this.zzayz.dump(String.valueOf(string2).concat("  "), fileDescriptor, printWriter, stringArray);
        }
    }
}

